/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.spi.ContextAware;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class StringToObjectConverter {
    private static final Class<?>[] STING_CLASS_PARAMETER = new Class[]{String.class};

    public static boolean canBeBuiltFromSimpleString(Class<?> parameterClass) {
        Package p2 = parameterClass.getPackage();
        if (parameterClass.isPrimitive()) {
            return true;
        }
        if (p2 != null && "java.lang".equals(p2.getName())) {
            return true;
        }
        if (StringToObjectConverter.followsTheValueOfConvention(parameterClass)) {
            return true;
        }
        if (parameterClass.isEnum()) {
            return true;
        }
        return StringToObjectConverter.isOfTypeCharset(parameterClass);
    }

    public static Object convertArg(ContextAware ca2, String val, Class<?> type) {
        if (val == null) {
            return null;
        }
        String v2 = val.trim();
        if (String.class.isAssignableFrom(type)) {
            return v2;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new Integer(v2);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new Long(v2);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return new Float(v2);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return new Double(v2);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v2)) {
                return Boolean.FALSE;
            }
        } else {
            if (type.isEnum()) {
                return StringToObjectConverter.convertToEnum(ca2, v2, type);
            }
            if (StringToObjectConverter.followsTheValueOfConvention(type)) {
                return StringToObjectConverter.convertByValueOfMethod(ca2, type, v2);
            }
            if (StringToObjectConverter.isOfTypeCharset(type)) {
                return StringToObjectConverter.convertToCharset(ca2, val);
            }
        }
        return null;
    }

    private static boolean isOfTypeCharset(Class<?> type) {
        return Charset.class.isAssignableFrom(type);
    }

    private static Charset convertToCharset(ContextAware ca2, String val) {
        try {
            return Charset.forName(val);
        }
        catch (UnsupportedCharsetException e2) {
            ca2.addError("Failed to get charset [" + val + "]", e2);
            return null;
        }
    }

    public static Method getValueOfMethod(Class<?> type) {
        try {
            return type.getMethod("valueOf", STING_CLASS_PARAMETER);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
        catch (SecurityException e3) {
            return null;
        }
    }

    private static boolean followsTheValueOfConvention(Class<?> parameterClass) {
        Method valueOfMethod = StringToObjectConverter.getValueOfMethod(parameterClass);
        if (valueOfMethod == null) {
            return false;
        }
        int mod = valueOfMethod.getModifiers();
        return Modifier.isStatic(mod);
    }

    private static Object convertByValueOfMethod(ContextAware ca2, Class<?> type, String val) {
        try {
            Method valueOfMethod = type.getMethod("valueOf", STING_CLASS_PARAMETER);
            return valueOfMethod.invoke(null, val);
        }
        catch (Exception e2) {
            ca2.addError("Failed to invoke valueOf{} method in class [" + type.getName() + "] with value [" + val + "]");
            return null;
        }
    }

    private static Object convertToEnum(ContextAware ca2, String val, Class<? extends Enum> enumType) {
        return Enum.valueOf(enumType, val);
    }

    boolean isBuildableFromSimpleString() {
        return false;
    }
}

