/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes;

import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.SeparatorMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaintOrder {
    public static final PaintOrder NORMAL = new PaintOrder(Phase.FILL, Phase.STROKE, Phase.MARKERS);
    @NotNull
    private final Phase[] phases;

    public PaintOrder(Phase ... phases) {
        this.phases = phases;
    }

    @NotNull
    public Phase[] phases() {
        return this.phases;
    }

    @NotNull
    public static PaintOrder parse(@NotNull AttributeNode attributeNode) {
        @Nullable String value = attributeNode.getValue("paint-order");
        @NotNull AttributeParser parser = attributeNode.parser();
        if (value == null || "normal".equals(value)) {
            return NORMAL;
        }
        String[] rawPhases = parser.parseStringList(value, SeparatorMode.COMMA_AND_WHITESPACE);
        Phase[] phases = new Phase[3];
        int length = Math.min(phases.length, rawPhases.length);
        int i2 = 0;
        while (i2 < length) {
            phases[i2] = parser.parseEnum(rawPhases[i2], Phase.class);
            if (phases[i2] == null) continue;
            ++i2;
        }
        while (i2 < 3) {
            phases[i2] = PaintOrder.findNextInNormalOrder(phases, i2);
            ++i2;
        }
        return new PaintOrder(phases);
    }

    @NotNull
    private static Phase findNextInNormalOrder(@NotNull Phase[] phases, int maxIndex) {
        for (Phase phase : NORMAL.phases()) {
            boolean found = false;
            for (int i2 = 0; i2 < maxIndex; ++i2) {
                if (phases[i2] != phase) continue;
                found = true;
                break;
            }
            if (found) continue;
            return phase;
        }
        throw new IllegalStateException();
    }

    public static enum Phase {
        FILL,
        STROKE,
        MARKERS;

    }
}

