/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.devtools.DevToolsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class SceneOverlay
extends Overlay {
    private static final Color MAP_SQUARE_COLOR = Color.GREEN;
    private static final Color CHUNK_BORDER_COLOR = Color.BLUE;
    private static final Color LOCAL_VALID_MOVEMENT_COLOR = new Color(141, 220, 26);
    private static final Color VALID_MOVEMENT_COLOR = new Color(73, 122, 18);
    private static final Color LINE_OF_SIGHT_COLOR = new Color(204, 42, 219);
    private static final Color INTERACTING_COLOR = Color.CYAN;
    private static final int LOCAL_TILE_SIZE = 128;
    private static final int MAP_SQUARE_SIZE = 64;
    private static final int CULL_CHUNK_BORDERS_RANGE = 16;
    private static final int STROKE_WIDTH = 4;
    private static final int CULL_LINE_OF_SIGHT_RANGE = 10;
    private static final int INTERACTING_SHIFT = -16;
    private static final Polygon ARROW_HEAD = new Polygon(new int[]{0, -3, 3}, new int[]{0, -5, -5}, 3);
    private final Client client;
    private final DevToolsPlugin plugin;

    @Inject
    public SceneOverlay(Client client2, DevToolsPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client2;
        this.plugin = plugin;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getZoneBorders().isActive()) {
            this.renderZoneBorders(graphics);
        }
        if (this.plugin.getMapSquares().isActive()) {
            this.renderMapSquares(graphics);
        }
        if (this.plugin.getLoadingLines().isActive()) {
            this.renderLoadingLines(graphics);
        }
        if (this.plugin.getLineOfSight().isActive()) {
            this.renderLineOfSight(graphics);
        }
        if (this.plugin.getValidMovement().isActive()) {
            this.renderValidMovement(graphics);
        }
        if (this.plugin.getInteracting().isActive()) {
            this.renderInteracting(graphics);
        }
        return null;
    }

    private void renderZoneBorders(Graphics2D graphics) {
        Point p2;
        LocalPoint lp;
        boolean first;
        int startX = 8;
        int startZ = 8;
        int endX = 96;
        int endZ = 96;
        graphics.setStroke(new BasicStroke(4.0f));
        graphics.setColor(CHUNK_BORDER_COLOR);
        GeneralPath path = new GeneralPath();
        for (int x2 = startX; x2 <= endX; x2 += 8) {
            first = true;
            for (int z2 = startZ; z2 <= endZ; z2 += 8) {
                lp = new LocalPoint(x2 << 7, z2 << 7);
                p2 = Perspective.localToCanvas(this.client, lp, this.client.getPlane());
                if (p2 == null) continue;
                if (first) {
                    path.moveTo(p2.getX(), p2.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p2.getX(), p2.getY());
            }
        }
        for (int z3 = startZ; z3 <= endZ; z3 += 8) {
            first = true;
            for (int x3 = startX; x3 <= endX; x3 += 8) {
                lp = new LocalPoint(x3 << 7, z3 << 7);
                p2 = Perspective.localToCanvas(this.client, lp, this.client.getPlane());
                if (p2 == null) continue;
                if (first) {
                    path.moveTo(p2.getX(), p2.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p2.getX(), p2.getY());
            }
        }
        graphics.draw(path);
    }

    private void renderLoadingLines(Graphics2D graphics) {
        graphics.setStroke(new BasicStroke(4.0f));
        graphics.setColor(CHUNK_BORDER_COLOR);
        int off = 2048;
        int max = 13312;
        LocalPoint[] points = new LocalPoint[]{new LocalPoint(off, off), new LocalPoint(off, max - off), new LocalPoint(max - off, max - off), new LocalPoint(max - off, off)};
        for (int i2 = 0; i2 < 4; ++i2) {
            LocalPoint lp0 = points[i2];
            LocalPoint lp1 = points[(i2 + 1) % 4];
            Point p0 = Perspective.localToCanvas(this.client, lp0, this.client.getPlane());
            Point p1 = Perspective.localToCanvas(this.client, lp1, this.client.getPlane());
            if (p0 == null || p1 == null) continue;
            graphics.drawLine(p0.getX(), p0.getY(), p1.getX(), p1.getY());
        }
    }

    private void renderMapSquares(Graphics2D graphics) {
        Point p2;
        boolean first;
        LocalPoint lp2;
        LocalPoint lp1;
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int startX = (wp.getX() - 16 + 64 - 1) / 64 * 64;
        int startY = (wp.getY() - 16 + 64 - 1) / 64 * 64;
        int endX = (wp.getX() + 16) / 64 * 64;
        int endY = (wp.getY() + 16) / 64 * 64;
        graphics.setStroke(new BasicStroke(4.0f));
        graphics.setColor(MAP_SQUARE_COLOR);
        GeneralPath path = new GeneralPath();
        for (int x2 = startX; x2 <= endX; x2 += 64) {
            lp1 = LocalPoint.fromWorld(this.client, x2, wp.getY() - 16);
            lp2 = LocalPoint.fromWorld(this.client, x2, wp.getY() + 16);
            first = true;
            for (int y2 = lp1.getY(); y2 <= lp2.getY(); y2 += 128) {
                p2 = Perspective.localToCanvas(this.client, new LocalPoint(lp1.getX() - 64, y2 - 64), this.client.getPlane());
                if (p2 == null) continue;
                if (first) {
                    path.moveTo(p2.getX(), p2.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p2.getX(), p2.getY());
            }
        }
        for (int y3 = startY; y3 <= endY; y3 += 64) {
            lp1 = LocalPoint.fromWorld(this.client, wp.getX() - 16, y3);
            lp2 = LocalPoint.fromWorld(this.client, wp.getX() + 16, y3);
            first = true;
            for (int x3 = lp1.getX(); x3 <= lp2.getX(); x3 += 128) {
                p2 = Perspective.localToCanvas(this.client, new LocalPoint(x3 - 64, lp1.getY() - 64), this.client.getPlane());
                if (p2 == null) continue;
                if (first) {
                    path.moveTo(p2.getX(), p2.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p2.getX(), p2.getY());
            }
        }
        graphics.draw(path);
    }

    private void renderTileIfValidForMovement(Graphics2D graphics, Actor actor, int dx2, int dy2) {
        WorldArea area = actor.getWorldArea();
        if (area == null) {
            return;
        }
        if (area.canTravelInDirection(this.client.getTopLevelWorldView(), dx2, dy2)) {
            LocalPoint lp = actor.getLocalLocation();
            if (lp == null) {
                return;
            }
            Polygon poly = Perspective.getCanvasTilePoly(this.client, lp = new LocalPoint(lp.getX() + dx2 * 128 + dx2 * 128 * (area.getWidth() - 1) / 2, lp.getY() + dy2 * 128 + dy2 * 128 * (area.getHeight() - 1) / 2));
            if (poly == null) {
                return;
            }
            if (actor == this.client.getLocalPlayer()) {
                OverlayUtil.renderPolygon(graphics, poly, LOCAL_VALID_MOVEMENT_COLOR);
            } else {
                OverlayUtil.renderPolygon(graphics, poly, VALID_MOVEMENT_COLOR);
            }
        }
    }

    private void renderValidMovement(Graphics2D graphics) {
        Player player = this.client.getLocalPlayer();
        List<NPC> npcs = this.client.getNpcs();
        for (NPC npc : npcs) {
            if (player.getInteracting() != npc && npc.getInteracting() != player) continue;
            for (int dx2 = -1; dx2 <= 1; ++dx2) {
                for (int dy2 = -1; dy2 <= 1; ++dy2) {
                    if (dx2 == 0 && dy2 == 0) continue;
                    this.renderTileIfValidForMovement(graphics, npc, dx2, dy2);
                }
            }
        }
        for (int dx3 = -1; dx3 <= 1; ++dx3) {
            for (int dy3 = -1; dy3 <= 1; ++dy3) {
                if (dx3 == 0 && dy3 == 0) continue;
                this.renderTileIfValidForMovement(graphics, player, dx3, dy3);
            }
        }
    }

    private void renderTileIfHasLineOfSight(Graphics2D graphics, WorldArea start, int targetX, int targetY) {
        WorldPoint targetLocation = new WorldPoint(targetX, targetY, start.getPlane());
        if (start.hasLineOfSightTo(this.client.getTopLevelWorldView(), targetLocation)) {
            LocalPoint lp = LocalPoint.fromWorld(this.client, targetLocation);
            if (lp == null) {
                return;
            }
            Polygon poly = Perspective.getCanvasTilePoly(this.client, lp);
            if (poly == null) {
                return;
            }
            OverlayUtil.renderPolygon(graphics, poly, LINE_OF_SIGHT_COLOR);
        }
    }

    private void renderLineOfSight(Graphics2D graphics) {
        WorldArea area = this.client.getLocalPlayer().getWorldArea();
        for (int x2 = area.getX() - 10; x2 <= area.getX() + 10; ++x2) {
            for (int y2 = area.getY() - 10; y2 <= area.getY() + 10; ++y2) {
                if (x2 == area.getX() && y2 == area.getY()) continue;
                this.renderTileIfHasLineOfSight(graphics, area, x2, y2);
            }
        }
    }

    private void renderInteracting(Graphics2D graphics) {
        Stream.concat(this.client.getPlayers().stream(), this.client.getNpcs().stream()).forEach(fa2 -> {
            Actor ta = fa2.getInteracting();
            if (ta == null) {
                return;
            }
            LocalPoint fl2 = fa2.getLocalLocation();
            Point fs2 = Perspective.localToCanvas(this.client, fl2, this.client.getPlane(), fa2.getLogicalHeight() / 2);
            if (fs2 == null) {
                return;
            }
            int fsx = fs2.getX();
            int fsy = fs2.getY() - -16;
            LocalPoint tl = ta.getLocalLocation();
            Point ts = Perspective.localToCanvas(this.client, tl, this.client.getPlane(), ta.getLogicalHeight() / 2);
            if (ts == null) {
                return;
            }
            int tsx = ts.getX();
            int tsy = ts.getY() - -16;
            graphics.setColor(INTERACTING_COLOR);
            graphics.drawLine(fsx, fsy, tsx, tsy);
            AffineTransform t2 = new AffineTransform();
            t2.translate(tsx, tsy);
            t2.rotate(tsx - fsx, tsy - fsy);
            t2.rotate(-1.5707963267948966);
            AffineTransform ot = graphics.getTransform();
            graphics.setTransform(t2);
            graphics.fill(ARROW_HEAD);
            graphics.setTransform(ot);
        });
    }
}

