/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grandexchange;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.plugins.grandexchange.GrandExchangePlugin;
import net.runelite.client.util.Text;

public class GrandExchangeInputListener
extends MouseAdapter
implements KeyListener {
    private final Client client;
    private final GrandExchangePlugin plugin;

    @Inject
    private GrandExchangeInputListener(Client client2, GrandExchangePlugin plugin) {
        this.client = client2;
        this.plugin = plugin;
    }

    @Override
    public MouseEvent mouseClicked(MouseEvent e2) {
        if (e2.getButton() == 1 && e2.isAltDown()) {
            MenuEntry[] menuEntries;
            for (MenuEntry menuEntry : menuEntries = this.client.getMenuEntries()) {
                if (!menuEntry.getOption().equals("Search Grand Exchange")) continue;
                this.plugin.search(Text.removeTags(menuEntry.getTarget()));
                e2.consume();
                break;
            }
        }
        return super.mouseClicked(e2);
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        if (e2.isAltDown()) {
            this.plugin.setHotKeyPressed(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (!e2.isAltDown()) {
            this.plugin.setHotKeyPressed(false);
        }
    }
}

