/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.keyremapping;

import com.google.common.base.Strings;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.KeyListener;
import net.runelite.client.plugins.keyremapping.KeyRemappingConfig;
import net.runelite.client.plugins.keyremapping.KeyRemappingPlugin;

class KeyRemappingListener
implements KeyListener {
    @Inject
    private KeyRemappingPlugin plugin;
    @Inject
    private KeyRemappingConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private final Map<Integer, Integer> modified = new HashMap<Integer, Integer>();
    private final Set<Character> blockedChars = new HashSet<Character>();

    KeyRemappingListener() {
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        char keyChar = e2.getKeyChar();
        if (keyChar != '\uffff' && this.blockedChars.contains(Character.valueOf(keyChar)) && this.plugin.chatboxFocused()) {
            e2.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        if (!this.plugin.chatboxFocused()) {
            return;
        }
        if (!this.plugin.isTyping()) {
            int mappedKeyCode = 0;
            if (this.config.cameraRemap()) {
                if (this.config.up().matches(e2)) {
                    mappedKeyCode = 38;
                } else if (this.config.down().matches(e2)) {
                    mappedKeyCode = 40;
                } else if (this.config.left().matches(e2)) {
                    mappedKeyCode = 37;
                } else if (this.config.right().matches(e2)) {
                    mappedKeyCode = 39;
                }
            }
            if (this.config.fkeyRemap() && !this.plugin.isDialogOpen()) {
                if (this.config.f1().matches(e2)) {
                    mappedKeyCode = 112;
                } else if (this.config.f2().matches(e2)) {
                    mappedKeyCode = 113;
                } else if (this.config.f3().matches(e2)) {
                    mappedKeyCode = 114;
                } else if (this.config.f4().matches(e2)) {
                    mappedKeyCode = 115;
                } else if (this.config.f5().matches(e2)) {
                    mappedKeyCode = 116;
                } else if (this.config.f6().matches(e2)) {
                    mappedKeyCode = 117;
                } else if (this.config.f7().matches(e2)) {
                    mappedKeyCode = 118;
                } else if (this.config.f8().matches(e2)) {
                    mappedKeyCode = 119;
                } else if (this.config.f9().matches(e2)) {
                    mappedKeyCode = 120;
                } else if (this.config.f10().matches(e2)) {
                    mappedKeyCode = 121;
                } else if (this.config.f11().matches(e2)) {
                    mappedKeyCode = 122;
                } else if (this.config.f12().matches(e2)) {
                    mappedKeyCode = 123;
                } else if (this.config.esc().matches(e2)) {
                    mappedKeyCode = 27;
                }
            }
            if (this.plugin.isDialogOpen() && !this.plugin.isOptionsDialogOpen() && this.config.space().matches(e2)) {
                mappedKeyCode = 32;
            }
            if (this.config.control().matches(e2)) {
                mappedKeyCode = 17;
            }
            if (mappedKeyCode != 0 && mappedKeyCode != e2.getKeyCode()) {
                char keyChar = e2.getKeyChar();
                this.modified.put(e2.getKeyCode(), mappedKeyCode);
                e2.setKeyCode(mappedKeyCode);
                e2.setKeyChar('\uffff');
                if (keyChar != '\uffff') {
                    this.blockedChars.add(Character.valueOf(keyChar));
                }
            }
            switch (e2.getKeyCode()) {
                case 10: 
                case 47: 
                case 513: {
                    this.plugin.setTyping(true);
                    this.clientThread.invoke(this.plugin::unlockChat);
                }
            }
        } else {
            switch (e2.getKeyCode()) {
                case 27: {
                    e2.consume();
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(() -> {
                        this.client.setVarcStrValue(335, "");
                        this.plugin.lockChat();
                    });
                    break;
                }
                case 10: {
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(this.plugin::lockChat);
                    break;
                }
                case 8: {
                    if (!Strings.isNullOrEmpty(this.client.getVarcStrValue(335))) break;
                    this.plugin.setTyping(false);
                    this.clientThread.invoke(this.plugin::lockChat);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        Integer mappedKeyCode;
        int keyCode = e2.getKeyCode();
        char keyChar = e2.getKeyChar();
        if (keyChar != '\uffff') {
            this.blockedChars.remove(Character.valueOf(keyChar));
        }
        if ((mappedKeyCode = this.modified.remove(keyCode)) != null) {
            e2.setKeyCode(mappedKeyCode);
            e2.setKeyChar('\uffff');
        }
    }
}

