/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.puzzlesolver.solver.heuristics;

import net.runelite.client.plugins.puzzlesolver.solver.PuzzleState;
import net.runelite.client.plugins.puzzlesolver.solver.heuristics.Heuristic;

public class ManhattanDistance
implements Heuristic {
    @Override
    public int computeValue(PuzzleState state) {
        int value = 0;
        PuzzleState parent = state.getParent();
        if (parent == null) {
            for (int x2 = 0; x2 < 5; ++x2) {
                for (int y2 = 0; y2 < 5; ++y2) {
                    int piece = state.getPiece(x2, y2);
                    if (piece == -1) continue;
                    int goalX = piece % 5;
                    int goalY = piece / 5;
                    value += Math.abs(x2 - goalX) + Math.abs(y2 - goalY);
                }
            }
        } else {
            int targetY;
            int targetX;
            value = parent.getHeuristicValue(this);
            int x3 = parent.getEmptyPiece() % 5;
            int y3 = parent.getEmptyPiece() / 5;
            int x2 = state.getEmptyPiece() % 5;
            int y2 = state.getEmptyPiece() / 5;
            int piece = state.getPiece(x3, y3);
            value = x2 > x3 ? ((targetX = piece % 5) > x3 ? ++value : --value) : (x2 < x3 ? ((targetX = piece % 5) < x3 ? ++value : --value) : (y2 > y3 ? ((targetY = piece / 5) > y3 ? ++value : --value) : ((targetY = piece / 5) < y3 ? ++value : --value)));
        }
        return value;
    }
}

