/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids;

import java.util.Arrays;
import java.util.List;
import net.runelite.client.plugins.raids.RaidRoom;
import net.runelite.client.plugins.raids.RoomType;

class RotationSolver {
    private static final List[] ROTATIONS = new List[]{Arrays.asList(RaidRoom.TEKTON, RaidRoom.VASA, RaidRoom.GUARDIANS, RaidRoom.MYSTICS, RaidRoom.SHAMANS, RaidRoom.MUTTADILES, RaidRoom.VANGUARDS, RaidRoom.VESPULA), Arrays.asList(RaidRoom.TEKTON, RaidRoom.MUTTADILES, RaidRoom.GUARDIANS, RaidRoom.VESPULA, RaidRoom.SHAMANS, RaidRoom.VASA, RaidRoom.VANGUARDS, RaidRoom.MYSTICS), Arrays.asList(RaidRoom.VESPULA, RaidRoom.VANGUARDS, RaidRoom.MUTTADILES, RaidRoom.SHAMANS, RaidRoom.MYSTICS, RaidRoom.GUARDIANS, RaidRoom.VASA, RaidRoom.TEKTON), Arrays.asList(RaidRoom.MYSTICS, RaidRoom.VANGUARDS, RaidRoom.VASA, RaidRoom.SHAMANS, RaidRoom.VESPULA, RaidRoom.GUARDIANS, RaidRoom.MUTTADILES, RaidRoom.TEKTON)};

    RotationSolver() {
    }

    static boolean solve(RaidRoom[] rooms) {
        if (rooms == null) {
            return false;
        }
        List match = null;
        Integer start = null;
        Integer index = null;
        int known = 0;
        for (int i2 = 0; i2 < rooms.length; ++i2) {
            if (rooms[i2] == null || rooms[i2].getType() != RoomType.COMBAT || rooms[i2] == RaidRoom.UNKNOWN_COMBAT) continue;
            if (start == null) {
                start = i2;
            }
            ++known;
        }
        if (known < 2) {
            return false;
        }
        if (known == rooms.length) {
            return true;
        }
        block1: for (List rotation : ROTATIONS) {
            for (int i3 = 0; i3 < rotation.size(); ++i3) {
                if (rooms[start] != rotation.get(i3)) continue;
                for (int j2 = start + 1; j2 < rooms.length; ++j2) {
                    if (rooms[j2].getType() == RoomType.COMBAT && rooms[j2] != RaidRoom.UNKNOWN_COMBAT && rooms[j2] != rotation.get(Math.floorMod(i3 + j2 - start, rotation.size()))) continue block1;
                }
                if (match != null && match != rotation) {
                    return false;
                }
                index = i3 - start;
                match = rotation;
            }
        }
        if (match == null) {
            return false;
        }
        for (int i4 = 0; i4 < rooms.length; ++i4) {
            if (rooms[i4] == null || rooms[i4].getType() == RoomType.COMBAT && rooms[i4] != RaidRoom.UNKNOWN_COMBAT) continue;
            rooms[i4] = (RaidRoom)((Object)match.get(Math.floorMod(index + i4, match.size())));
        }
        return true;
    }
}

