/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.function.Function;

public class DynamicGridLayout
extends GridLayout {
    public DynamicGridLayout() {
        this(1, 0, 0, 0);
    }

    public DynamicGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public DynamicGridLayout(int rows, int cols, int hgap, int vgap) {
        super(rows, cols, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.calculateSize(parent, Component::getPreferredSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.calculateSize(parent, Component::getMinimumSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getRows();
            int ncols = this.getColumns();
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Dimension pd = this.preferredLayoutSize(parent);
            Insets parentInsets = parent.getInsets();
            int wborder = parentInsets.left + parentInsets.right;
            int hborder = parentInsets.top + parentInsets.bottom;
            double sw = (1.0 * (double)parent.getWidth() - (double)wborder) / (double)(pd.width - wborder);
            double sh = (1.0 * (double)parent.getHeight() - (double)hborder) / (double)(pd.height - hborder);
            int[] w2 = new int[ncols];
            int[] h2 = new int[nrows];
            for (int i2 = 0; i2 < ncomponents; ++i2) {
                int r2 = i2 / ncols;
                int c2 = i2 % ncols;
                Component comp = parent.getComponent(i2);
                Dimension d2 = comp.getPreferredSize();
                d2.width = (int)(sw * (double)d2.width);
                d2.height = (int)(sh * (double)d2.height);
                if (w2[c2] < d2.width) {
                    w2[c2] = d2.width;
                }
                if (h2[r2] >= d2.height) continue;
                h2[r2] = d2.height;
            }
            int x2 = insets.left;
            for (int c3 = 0; c3 < ncols; ++c3) {
                int y2 = insets.top;
                for (int r3 = 0; r3 < nrows; ++r3) {
                    int i3 = r3 * ncols + c3;
                    if (i3 < ncomponents) {
                        parent.getComponent(i3).setBounds(x2, y2, w2[c3], h2[r3]);
                    }
                    y2 += h2[r3] + vgap;
                }
                x2 += w2[c3] + hgap;
            }
        }
    }

    private Dimension calculateSize(Container parent, Function<Component, Dimension> sizer) {
        int ncomponents = parent.getComponentCount();
        int nrows = this.getRows();
        int ncols = this.getColumns();
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int[] w2 = new int[ncols];
        int[] h2 = new int[nrows];
        for (int i2 = 0; i2 < ncomponents; ++i2) {
            int r2 = i2 / ncols;
            int c2 = i2 % ncols;
            Component comp = parent.getComponent(i2);
            Dimension d2 = sizer.apply(comp);
            if (w2[c2] < d2.width) {
                w2[c2] = d2.width;
            }
            if (h2[r2] >= d2.height) continue;
            h2[r2] = d2.height;
        }
        int nw = 0;
        for (int j2 = 0; j2 < ncols; ++j2) {
            nw += w2[j2];
        }
        int nh = 0;
        for (int i3 = 0; i3 < nrows; ++i3) {
            nh += h2[i3];
        }
        Insets insets = parent.getInsets();
        return new Dimension(insets.left + insets.right + nw + (ncols - 1) * this.getHgap(), insets.top + insets.bottom + nh + (nrows - 1) * this.getVgap());
    }
}

