/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.jshell;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.text.JTextComponent;
import jdk.jshell.JShell;
import jdk.jshell.SourceCodeAnalysis;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class JShellAutocompleteProvider
extends CompletionProviderBase {
    private final JShell shell;
    private String anchorText;
    private List<Completion> completions;

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        return this.completions;
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent comp) {
        this.complete(comp);
        return this.anchorText;
    }

    private void complete(JTextComponent comp) {
        this.completions = Collections.emptyList();
        String src = comp.getText();
        int cursor = comp.getCaretPosition();
        int offset = 0;
        while (offset < src.length() && cursor >= offset) {
            boolean mayHaveMore;
            String snipSrc = src.substring(offset);
            int thisOffset = offset;
            SourceCodeAnalysis.CompletionInfo ci2 = this.shell.sourceCodeAnalysis().analyzeCompletion(snipSrc);
            offset = src.length() - ci2.remaining().length();
            boolean bl2 = mayHaveMore = ci2.completeness() == SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI || ci2.completeness() == SourceCodeAnalysis.Completeness.COMPLETE;
            if (cursor > offset && mayHaveMore) continue;
            int[] anchor = new int[1];
            this.completions = this.shell.sourceCodeAnalysis().completionSuggestions(snipSrc, cursor - thisOffset, anchor).stream().filter(v2 -> !v2.continuation().startsWith("$")).map(s2 -> new BasicCompletion((CompletionProvider)this, s2.continuation())).collect(Collectors.toList());
            this.anchorText = snipSrc.substring(anchor[0], cursor - thisOffset);
            break;
        }
        if (this.completions.isEmpty()) {
            this.anchorText = null;
        }
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent comp, Point p2) {
        return Collections.emptyList();
    }

    @Override
    public boolean isAutoActivateOkay(JTextComponent comp) {
        String text = comp.getText();
        for (int i2 = comp.getCaretPosition(); i2 >= 0; --i2) {
            char c2 = text.charAt(i2);
            if (Character.isJavaIdentifierPart(c2) || c2 == '.' || c2 == '(') {
                return true;
            }
            if (Character.isWhitespace(c2)) continue;
            return false;
        }
        return false;
    }

    @Override
    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent tc) {
        return Collections.emptyList();
    }

    public JShellAutocompleteProvider(JShell shell) {
        this.shell = shell;
    }
}

