/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP128R1FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecP128R1Point;
import org.bouncycastle.math.raw.Nat128;
import org.bouncycastle.util.encoders.Hex;

public class SecP128R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"));
    private static final int SecP128R1_DEFAULT_COORDS = 2;
    protected SecP128R1Point infinity = new SecP128R1Point(this, null, null);

    public SecP128R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("E87579C11079F43DD824993C2CEE5ED3")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFE0000000075A30D1B9038A115"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP128R1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP128R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP128R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP128R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        final int[] nArray = new int[n3 * 4 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 4);
            n4 += 4;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n3;
            }

            public ECPoint lookup(int n2) {
                int[] nArray3 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 4; ++i3) {
                        int n5 = i3;
                        nArray3[n5] = nArray3[n5] ^ nArray[n32 + i3] & n4;
                        int n6 = i3;
                        nArray2[n6] = nArray2[n6] ^ nArray[n32 + 4 + i3] & n4;
                    }
                    n32 += 8;
                }
                return SecP128R1Curve.this.createRawPoint(new SecP128R1FieldElement(nArray3), new SecP128R1FieldElement(nArray2), false);
            }
        };
    }
}

