/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip;
import org.fife.ui.rsyntaxtextarea.focusabletip.SizeGrip;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;

class TipWindow
extends JWindow
implements ActionListener {
    private FocusableTip ft;
    private JEditorPane textArea;
    private String text;
    private transient TipListener tipListener;
    private transient HyperlinkListener userHyperlinkListener;
    private static TipWindow visibleInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TipWindow(Window owner, FocusableTip ft2, String msg) {
        super(owner);
        this.ft = ft2;
        if (msg != null && msg.length() >= 6 && !msg.substring(0, 6).toLowerCase().equals("<html>")) {
            msg = "<html>" + RSyntaxUtilities.escapeForHtml(msg, "<br>", false);
        }
        this.text = msg;
        this.tipListener = new TipListener();
        JPanel cp2 = new JPanel(new BorderLayout());
        cp2.setBorder(TipUtil.getToolTipBorder());
        cp2.setBackground(TipUtil.getToolTipBackground());
        this.textArea = new JEditorPane("text/html", this.text);
        TipUtil.tweakTipEditorPane(this.textArea);
        if (ft2.getImageBase() != null) {
            ((HTMLDocument)this.textArea.getDocument()).setBase(ft2.getImageBase());
        }
        this.textArea.addMouseListener(this.tipListener);
        this.textArea.addHyperlinkListener(e2 -> {
            if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.ft.possiblyDisposeOfTipWindow();
            }
        });
        cp2.add(this.textArea);
        this.setFocusableWindowState(false);
        this.setContentPane(cp2);
        this.setBottomPanel();
        this.pack();
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 27) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        };
        this.addKeyListener(ka);
        this.textArea.addKeyListener(ka);
        Class<TipWindow> clazz = TipWindow.class;
        synchronized (TipWindow.class) {
            if (visibleInstance != null) {
                visibleInstance.dispose();
            }
            visibleInstance = this;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (!this.getFocusableWindowState()) {
            this.setFocusableWindowState(true);
            this.setBottomPanel();
            this.textArea.removeMouseListener(this.tipListener);
            this.pack();
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e2) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            });
            this.ft.removeListeners();
            if (e2 == null) {
                this.requestFocus();
            }
        }
    }

    @Override
    public void dispose() {
        Container cp2 = this.getContentPane();
        for (int i2 = 0; i2 < cp2.getComponentCount(); ++i2) {
            cp2.getComponent(i2).removeMouseListener(this.tipListener);
        }
        this.ft.removeListeners();
        super.dispose();
    }

    void fixSize() {
        Dimension d2 = this.textArea.getPreferredSize();
        Rectangle r2 = null;
        try {
            r2 = this.textArea.modelToView(this.textArea.getDocument().getLength() - 1);
            d2 = this.textArea.getPreferredSize();
            d2.width += 25;
            int maxWindowW = this.ft.getMaxSize() != null ? this.ft.getMaxSize().width : 600;
            int maxWindowH = this.ft.getMaxSize() != null ? this.ft.getMaxSize().height : 400;
            d2.width = Math.min(d2.width, maxWindowW);
            d2.height = Math.min(d2.height, maxWindowH);
            this.textArea.setPreferredSize(d2);
            this.textArea.setSize(d2);
            r2 = this.textArea.modelToView(this.textArea.getDocument().getLength() - 1);
            if (r2.y + r2.height > d2.height) {
                d2.height = r2.y + r2.height + 5;
                if (this.ft.getMaxSize() != null) {
                    d2.height = Math.min(d2.height, maxWindowH);
                }
                this.textArea.setPreferredSize(d2);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.pack();
    }

    public String getText() {
        return this.text;
    }

    private void setBottomPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JSeparator(), "North");
        boolean focusable = this.getFocusableWindowState();
        if (focusable) {
            SizeGrip sg = new SizeGrip();
            sg.applyComponentOrientation(sg.getComponentOrientation());
            panel.add((Component)sg, "After");
            MouseInputAdapter adapter = new MouseInputAdapter(){
                private Point lastPoint;

                @Override
                public void mouseDragged(MouseEvent e2) {
                    Point p2 = e2.getPoint();
                    SwingUtilities.convertPointToScreen(p2, panel);
                    if (this.lastPoint == null) {
                        this.lastPoint = p2;
                    } else {
                        int dx2 = p2.x - this.lastPoint.x;
                        int dy2 = p2.y - this.lastPoint.y;
                        TipWindow.this.setLocation(TipWindow.this.getX() + dx2, TipWindow.this.getY() + dy2);
                        this.lastPoint = p2;
                    }
                }

                @Override
                public void mousePressed(MouseEvent e2) {
                    this.lastPoint = e2.getPoint();
                    SwingUtilities.convertPointToScreen(this.lastPoint, panel);
                }
            };
            panel.addMouseListener(adapter);
            panel.addMouseMotionListener(adapter);
        } else {
            panel.setOpaque(false);
            JLabel label = new JLabel(FocusableTip.getString("FocusHotkey"));
            Color fg2 = UIManager.getColor("Label.disabledForeground");
            Font font = this.textArea.getFont();
            font = font.deriveFont(font.getSize2D() - 1.0f);
            label.setFont(font);
            if (fg2 == null) {
                fg2 = Color.GRAY;
            }
            label.setOpaque(true);
            Color bg2 = TipUtil.getToolTipBackground();
            label.setBackground(bg2);
            label.setForeground(fg2);
            label.setHorizontalAlignment(11);
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            panel.add(label);
            panel.addMouseListener(this.tipListener);
        }
        Container cp2 = this.getContentPane();
        if (cp2.getComponentCount() == 2) {
            Component comp = cp2.getComponent(0);
            cp2.remove(0);
            JScrollPane sp = new JScrollPane(comp);
            Border emptyBorder = BorderFactory.createEmptyBorder();
            sp.setBorder(emptyBorder);
            sp.setViewportBorder(emptyBorder);
            sp.setBackground(this.textArea.getBackground());
            sp.getViewport().setBackground(this.textArea.getBackground());
            cp2.add(sp);
            cp2.getComponent(0).removeMouseListener(this.tipListener);
            cp2.remove(0);
        }
        cp2.add((Component)panel, "South");
    }

    public void setHyperlinkListener(HyperlinkListener listener) {
        if (this.userHyperlinkListener != null) {
            this.textArea.removeHyperlinkListener(this.userHyperlinkListener);
        }
        this.userHyperlinkListener = listener;
        if (this.userHyperlinkListener != null) {
            this.textArea.addHyperlinkListener(this.userHyperlinkListener);
        }
    }

    private final class TipListener
    extends MouseAdapter {
        private TipListener() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            TipWindow.this.actionPerformed(null);
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            Component source = (Component)e2.getSource();
            Point p2 = e2.getPoint();
            SwingUtilities.convertPointToScreen(p2, source);
            if (!TipWindow.this.getBounds().contains(p2)) {
                TipWindow.this.ft.possiblyDisposeOfTipWindow();
            }
        }
    }
}

