/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class LatexFoldParser
implements FoldParser {
    private static final char[] BEGIN = "\\begin".toCharArray();
    private static final char[] END = "\\end".toCharArray();

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Stack<String> expectedStack = new Stack<String>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        try {
            for (int line = 0; line < lineCount; ++line) {
                for (Token t2 = textArea.getTokenListForLine(line); t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
                    Token temp;
                    if (t2.is(6, BEGIN)) {
                        temp = t2.getNextToken();
                        if (temp == null || !temp.isLeftCurly() || (temp = temp.getNextToken()) == null || temp.getType() != 6) continue;
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t2.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t2.getOffset());
                        }
                        expectedStack.push(temp.getLexeme());
                        t2 = temp;
                        continue;
                    }
                    if (!t2.is(6, END) || currentFold == null || expectedStack.isEmpty() || (temp = t2.getNextToken()) == null || !temp.isLeftCurly() || (temp = temp.getNextToken()) == null || temp.getType() != 6) continue;
                    String value = temp.getLexeme();
                    if (!((String)expectedStack.peek()).equals(value)) continue;
                    expectedStack.pop();
                    currentFold.setEndOffset(t2.getOffset());
                    Fold parentFold = currentFold.getParent();
                    if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                        folds.remove(folds.size() - 1);
                    }
                    t2 = temp;
                    currentFold = parentFold;
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }
}

