/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SmartHighlightPainter
extends ChangeableHighlightPainter {
    private Color borderColor;
    private boolean paintBorder;

    public SmartHighlightPainter() {
        super(Color.BLUE);
    }

    public SmartHighlightPainter(Paint paint) {
        super(paint);
    }

    public boolean getPaintBorder() {
        return this.paintBorder;
    }

    @Override
    public Shape paintLayer(Graphics g2, int p0, int p1, Shape viewBounds, JTextComponent c2, View view) {
        g2.setColor((Color)this.getPaint());
        if (p0 == p1) {
            try {
                Shape s2 = view.modelToView(p0, viewBounds, Position.Bias.Forward);
                Rectangle r2 = s2.getBounds();
                g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height);
                return r2;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p0 == view.getStartOffset() && p1 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g2.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, viewBounds);
            Rectangle r3 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g2.fillRect(r3.x, r3.y, r3.width, r3.height);
            if (this.paintBorder) {
                g2.setColor(this.borderColor);
                g2.drawRect(r3.x, r3.y, r3.width - 1, r3.height - 1);
            }
            return r3;
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            this.borderColor = ((Color)paint).darker();
        }
    }

    public void setPaintBorder(boolean paint) {
        this.paintBorder = paint;
    }
}

